<?php
defined('BASEPATH') OR exit('No direct script access allowed');


/**
*| --------------------------------------------------------------------------
*| Transaction Item Controller
*| --------------------------------------------------------------------------
*| Transaction Item site
*|
*/
class Transaction_item extends Admin	
{
	
	public function __construct()
	{
		parent::__construct();

		$this->load->model('model_transaction_item');
		$this->load->model('group/model_group');
		$this->lang->load('web_lang', $this->current_lang);
	}

	/**
	* show all Transaction Items
	*
	* @var $offset String
	*/
	public function index($offset = 0)
	{
		$this->is_allowed('transaction_item_list');

		$filter = $this->input->get('q');
		$field 	= $this->input->get('f');

		$this->data['transaction_items'] = $this->model_transaction_item->get($filter, $field, $this->limit_page, $offset);
		$this->data['transaction_item_counts'] = $this->model_transaction_item->count_all($filter, $field);

		$config = [
			'base_url'     => ADMIN_NAMESPACE_URL  . '/transaction_item/index/',
			'total_rows'   => $this->data['transaction_item_counts'],
			'per_page'     => $this->limit_page,
			'uri_segment'  => 4,
		];

		$this->data['pagination'] = $this->pagination($config);
		
		$this->data['tables'] = $this->load->view('backend/standart/administrator/transaction_item/transaction_item_data_table', $this->data, true);
		
		if ($this->input->get('ajax')) {
			$this->response([
				'tables' => $this->data['tables'],
				'pagination' => $this->data['pagination'],
				'total_row' => $this->data['transaction_item_counts']
			]);
		}

		$this->template->title('Transaction Item List');
		$this->render('backend/standart/administrator/transaction_item/transaction_item_list', $this->data);
	}
	
	/**
	* Add new transaction_items
	*
	*/
	public function add()
	{
		$this->is_allowed('transaction_item_add');

		$this->template->title('Transaction Item New');
		$this->render('backend/standart/administrator/transaction_item/transaction_item_add', $this->data);
	}

	/**
	* Add New Transaction Items
	*
	* @return JSON
	*/
	public function add_save()
	{
		if (!$this->is_allowed('transaction_item_add', false)) {
			echo json_encode([
				'success' => false,
				'message' => cclang('sorry_you_do_not_have_permission_to_access')
				]);
			exit;
		}
		
		

		$this->form_validation->set_rules('product_id', 'Product Id', 'trim|required|max_length[11]');
		

		$this->form_validation->set_rules('qty', 'Qty', 'trim|required|max_length[11]');
		

		$this->form_validation->set_rules('transaction_id', 'Transaction Id', 'trim|required|max_length[11]');
		

		$this->form_validation->set_rules('total', 'Total', 'trim|required');
		

		

		if ($this->form_validation->run()) {
		
			$save_data = [
				'product_id' => $this->input->post('product_id'),
				'qty' => $this->input->post('qty'),
				'transaction_id' => $this->input->post('transaction_id'),
				'total' => $this->input->post('total'),
			];

			
			



			
			
			$save_transaction_item = $id = $this->model_transaction_item->store($save_data);
            

			if ($save_transaction_item) {
				
				
					
				
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = true;
					$this->data['id'] 	   = $save_transaction_item;
					$this->data['message'] = cclang('success_save_data_stay', [
						admin_anchor('/transaction_item/edit/' . $save_transaction_item, 'Edit Transaction Item'),
						admin_anchor('/transaction_item', ' Go back to list')
					]);
				} else {
					set_message(
						cclang('success_save_data_redirect', [
						admin_anchor('/transaction_item/edit/' . $save_transaction_item, 'Edit Transaction Item')
					]), 'success');

            		$this->data['success'] = true;
					$this->data['redirect'] = admin_base_url('/transaction_item');
				}
			} else {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = false;
					$this->data['message'] = cclang('data_not_change');
				} else {
            		$this->data['success'] = false;
            		$this->data['message'] = cclang('data_not_change');
					$this->data['redirect'] = admin_base_url('/transaction_item');
				}
			}

		} else {
			$this->data['success'] = false;
			$this->data['message'] = 'Opss validation failed';
			$this->data['errors'] = $this->form_validation->error_array();
		}

		$this->response($this->data);
	}
	
		/**
	* Update view Transaction Items
	*
	* @var $id String
	*/
	public function edit($id)
	{
		$this->is_allowed('transaction_item_update');

		$this->data['transaction_item'] = $this->model_transaction_item->find($id);

		$this->template->title('Transaction Item Update');
		$this->render('backend/standart/administrator/transaction_item/transaction_item_update', $this->data);
	}

	/**
	* Update Transaction Items
	*
	* @var $id String
	*/
	public function edit_save($id)
	{
		if (!$this->is_allowed('transaction_item_update', false)) {
			echo json_encode([
				'success' => false,
				'message' => cclang('sorry_you_do_not_have_permission_to_access')
				]);
			exit;
		}
				$this->form_validation->set_rules('product_id', 'Product Id', 'trim|required|max_length[11]');
		

		$this->form_validation->set_rules('qty', 'Qty', 'trim|required|max_length[11]');
		

		$this->form_validation->set_rules('transaction_id', 'Transaction Id', 'trim|required|max_length[11]');
		

		$this->form_validation->set_rules('total', 'Total', 'trim|required');
		

		
		if ($this->form_validation->run()) {
		
			$save_data = [
				'product_id' => $this->input->post('product_id'),
				'qty' => $this->input->post('qty'),
				'transaction_id' => $this->input->post('transaction_id'),
				'total' => $this->input->post('total'),
			];

			

			


			
			
			$save_transaction_item = $this->model_transaction_item->change($id, $save_data);

			if ($save_transaction_item) {

				

				
				
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = true;
					$this->data['id'] 	   = $id;
					$this->data['message'] = cclang('success_update_data_stay', [
						admin_anchor('/transaction_item', ' Go back to list')
					]);
				} else {
					set_message(
						cclang('success_update_data_redirect', [
					]), 'success');

            		$this->data['success'] = true;
					$this->data['redirect'] = admin_base_url('/transaction_item');
				}
			} else {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = false;
					$this->data['message'] = cclang('data_not_change');
				} else {
            		$this->data['success'] = false;
            		$this->data['message'] = cclang('data_not_change');
					$this->data['redirect'] = admin_base_url('/transaction_item');
				}
			}
		} else {
			$this->data['success'] = false;
			$this->data['message'] = 'Opss validation failed';
			$this->data['errors'] = $this->form_validation->error_array();
		}

		$this->response($this->data);
	}
	
	/**
	* delete Transaction Items
	*
	* @var $id String
	*/
	public function delete($id = null)
	{
		$this->is_allowed('transaction_item_delete');

		$this->load->helper('file');

		$arr_id = $this->input->get('id');
		$remove = false;

		if (!empty($id)) {
			$remove = $this->_remove($id);
		} elseif (count($arr_id) >0) {
			foreach ($arr_id as $id) {
				$remove = $this->_remove($id);
			}
		}

		if ($this->input->get('ajax')) {
			if ($remove) {
				$this->response([
					"success" => true,
					"message" => cclang('has_been_deleted', 'transaction_item')
				]);
			} else {
				$this->response([
					"success" => true,
					"message" => cclang('error_delete', 'transaction_item')
				]);
			}

		} else {
			if ($remove) {
				set_message(cclang('has_been_deleted', 'transaction_item'), 'success');
			} else {
				set_message(cclang('error_delete', 'transaction_item'), 'error');
			}
			redirect_back();
		}

	}

		/**
	* View view Transaction Items
	*
	* @var $id String
	*/
	public function view($id)
	{
		$this->is_allowed('transaction_item_view');

		$this->data['transaction_item'] = $this->model_transaction_item->join_avaiable()->filter_avaiable()->find($id);

		$this->template->title('Transaction Item Detail');
		$this->render('backend/standart/administrator/transaction_item/transaction_item_view', $this->data);
	}
	
	/**
	* delete Transaction Items
	*
	* @var $id String
	*/
	private function _remove($id)
	{
		$transaction_item = $this->model_transaction_item->find($id);

		
		
		return $this->model_transaction_item->remove($id);
	}
	
	
	/**
	* Export to excel
	*
	* @return Files Excel .xls
	*/
	public function export()
	{
		$this->is_allowed('transaction_item_export');

		$this->model_transaction_item->export(
			'transaction_item', 
			'transaction_item',
			$this->model_transaction_item->field_search
		);
	}

	/**
	* Export to PDF
	*
	* @return Files PDF .pdf
	*/
	public function export_pdf()
	{
		$this->is_allowed('transaction_item_export');

		$this->model_transaction_item->pdf('transaction_item', 'transaction_item');
	}


	public function single_pdf($id = null)
	{
		$this->is_allowed('transaction_item_export');

		$table = $title = 'transaction_item';
		$this->load->library('HtmlPdf');
      
        $config = array(
            'orientation' => 'p',
            'format' => 'a4',
            'marges' => array(5, 5, 5, 5)
        );

        $this->pdf = new HtmlPdf($config);
        $this->pdf->setDefaultFont('stsongstdlight'); 

        $result = $this->db->get($table);
       
        $data = $this->model_transaction_item->find($id);
        $fields = $result->list_fields();

        $content = $this->pdf->loadHtmlPdf('core_template/pdf/pdf_single', [
            'data' => $data,
            'fields' => $fields,
            'title' => $title
        ], TRUE);

        $this->pdf->initialize($config);
        $this->pdf->pdf->SetDisplayMode('fullpage');
        $this->pdf->writeHTML($content);
        $this->pdf->Output($table.'.pdf', 'H');
	}

	
}


/* End of file transaction_item.php */
/* Location: ./application/controllers/administrator/Transaction Item.php */