<?php foreach($transactions as $transaction): ?>
    <tr>
                <td width="5">
            <input type="checkbox" class="flat-red check" name="id[]" value="<?= $transaction->id; ?>">
        </td>
                
        <td><span class="list_group-user"><?= _ent($transaction->user); ?></span></td> 
        <td><span class="list_group-total"><?= _ent($transaction->total); ?></span></td> 
        <td><span class="list_group-name"><?= _ent($transaction->name); ?></span></td> 
        <td><span class="list_group-date"><?= _ent($transaction->date); ?></span></td> 
        <td>
            <?php if (!empty($transaction->image)): ?>
            <?php if (is_image($transaction->image)): ?>
            <a class="fancybox" rel="group" href="<?= BASE_URL . 'uploads/transaction/' . $transaction->image; ?>">
                <img src="<?= BASE_URL . 'uploads/transaction/' . $transaction->image; ?>" class="image-responsive" alt="image transaction" title="image transaction" width="40px">
            </a>
            <?php else: ?>
                <a href="<?= BASE_URL . 'uploads/transaction/' . $transaction->image; ?>" target="blank">
                <img src="<?= get_icon_file($transaction->image); ?>" class="image-responsive image-icon" alt="image transaction" title="image <?= $transaction->image; ?>" width="40px"> 
                </a>
            <?php endif; ?>
            <?php endif; ?>
        </td>
         
        <td width="200">
        
                        <?php is_allowed('transaction_view', function() use ($transaction){?>
                        <a href="<?= admin_site_url('/transaction/view/' . $transaction->id); ?>" data-id="<?= $transaction->id ?>" class="label-default btn-act-view"><i class="fa fa-newspaper-o"></i> <?= cclang('view_button'); ?>
            <?php }) ?>
            <?php is_allowed('transaction_update', function() use ($transaction){?>
            <a href="<?= admin_site_url('/transaction/edit/' . $transaction->id); ?>" data-id="<?= $transaction->id ?>" class="label-default btn-act-edit"><i class="fa fa-edit "></i> <?= cclang('update_button'); ?></a>
            <?php }) ?>
            <?php is_allowed('transaction_delete', function() use ($transaction){?>
            <a href="javascript:void(0);" data-href="<?= admin_site_url('/transaction/delete/' . $transaction->id); ?>" class="label-default remove-data"><i class="fa fa-close"></i> <?= cclang('remove_button'); ?></a>
            <?php }) ?>

        </td>    </tr>
    <?php endforeach; ?>
    <?php if ($transaction_counts == 0) :?>
        <tr>
        <td colspan="100">
        Transaction data is not available
        </td>
        </tr>
    <?php endif; ?>