<?php
defined('BASEPATH') OR exit('No direct script access allowed');


/**
*| --------------------------------------------------------------------------
*| Transaction Controller
*| --------------------------------------------------------------------------
*| Transaction site
*|
*/
class Transaction extends Admin	
{
	
	public function __construct()
	{
		parent::__construct();

		$this->load->model('model_transaction');
		$this->load->model('group/model_group');
		$this->lang->load('web_lang', $this->current_lang);
	}

	/**
	* show all Transactions
	*
	* @var $offset String
	*/
	public function index($offset = 0)
	{
		$this->is_allowed('transaction_list');

		$filter = $this->input->get('q');
		$field 	= $this->input->get('f');

		$this->data['transactions'] = $this->model_transaction->get($filter, $field, $this->limit_page, $offset);
		$this->data['transaction_counts'] = $this->model_transaction->count_all($filter, $field);

		$config = [
			'base_url'     => ADMIN_NAMESPACE_URL  . '/transaction/index/',
			'total_rows'   => $this->data['transaction_counts'],
			'per_page'     => $this->limit_page,
			'uri_segment'  => 4,
		];

		$this->data['pagination'] = $this->pagination($config);
		
		$this->data['tables'] = $this->load->view('backend/standart/administrator/transaction/transaction_data_table', $this->data, true);
		
		if ($this->input->get('ajax')) {
			$this->response([
				'tables' => $this->data['tables'],
				'pagination' => $this->data['pagination'],
				'total_row' => $this->data['transaction_counts']
			]);
		}

		$this->template->title('Transaction List');
		$this->render('backend/standart/administrator/transaction/transaction_list', $this->data);
	}
	
	/**
	* Add new transactions
	*
	*/
	public function add()
	{
		$this->is_allowed('transaction_add');

		$this->template->title('Transaction New');
		$this->render('backend/standart/administrator/transaction/transaction_add', $this->data);
	}

	/**
	* Add New Transactions
	*
	* @return JSON
	*/
	public function add_save()
	{
		if (!$this->is_allowed('transaction_add', false)) {
			echo json_encode([
				'success' => false,
				'message' => cclang('sorry_you_do_not_have_permission_to_access')
				]);
			exit;
		}
		
		

		$this->form_validation->set_rules('total', 'Total', 'trim|required');
		

		$this->form_validation->set_rules('date', 'Date', 'trim|required');
		

		

		if ($this->form_validation->run()) {
			$transaction_image_uuid = $this->input->post('transaction_image_uuid');
			$transaction_image_name = $this->input->post('transaction_image_name');
		
			$save_data = [
				'user' => get_user_data('id'),				'total' => $this->input->post('total'),
				'name' => $this->input->post('name'),
				'date' => $this->input->post('date'),
			];

			
			



			
			if (!is_dir(FCPATH . '/uploads/transaction/')) {
				mkdir(FCPATH . '/uploads/transaction/');
			}

			if (!empty($transaction_image_name)) {
				$transaction_image_name_copy = date('YmdHis') . '-' . $transaction_image_name;

				rename(FCPATH . 'uploads/tmp/' . $transaction_image_uuid . '/' . $transaction_image_name, 
						FCPATH . 'uploads/transaction/' . $transaction_image_name_copy);

				if (!is_file(FCPATH . '/uploads/transaction/' . $transaction_image_name_copy)) {
					echo json_encode([
						'success' => false,
						'message' => 'Error uploading file'
						]);
					exit;
				}

				$save_data['image'] = $transaction_image_name_copy;
			}
		
			
			$save_transaction = $id = $this->model_transaction->store($save_data);
            

			if ($save_transaction) {
				
				
					
				
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = true;
					$this->data['id'] 	   = $save_transaction;
					$this->data['message'] = cclang('success_save_data_stay', [
						admin_anchor('/transaction/edit/' . $save_transaction, 'Edit Transaction'),
						admin_anchor('/transaction', ' Go back to list')
					]);
				} else {
					set_message(
						cclang('success_save_data_redirect', [
						admin_anchor('/transaction/edit/' . $save_transaction, 'Edit Transaction')
					]), 'success');

            		$this->data['success'] = true;
					$this->data['redirect'] = admin_base_url('/transaction');
				}
			} else {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = false;
					$this->data['message'] = cclang('data_not_change');
				} else {
            		$this->data['success'] = false;
            		$this->data['message'] = cclang('data_not_change');
					$this->data['redirect'] = admin_base_url('/transaction');
				}
			}

		} else {
			$this->data['success'] = false;
			$this->data['message'] = 'Opss validation failed';
			$this->data['errors'] = $this->form_validation->error_array();
		}

		$this->response($this->data);
	}
	
		/**
	* Update view Transactions
	*
	* @var $id String
	*/
	public function edit($id)
	{
		$this->is_allowed('transaction_update');

		$this->data['transaction'] = $this->model_transaction->find($id);

		$this->template->title('Transaction Update');
		$this->render('backend/standart/administrator/transaction/transaction_update', $this->data);
	}

	/**
	* Update Transactions
	*
	* @var $id String
	*/
	public function edit_save($id)
	{
		if (!$this->is_allowed('transaction_update', false)) {
			echo json_encode([
				'success' => false,
				'message' => cclang('sorry_you_do_not_have_permission_to_access')
				]);
			exit;
		}
				$this->form_validation->set_rules('total', 'Total', 'trim|required');
		

		$this->form_validation->set_rules('date', 'Date', 'trim|required');
		

		
		if ($this->form_validation->run()) {
			$transaction_image_uuid = $this->input->post('transaction_image_uuid');
			$transaction_image_name = $this->input->post('transaction_image_name');
		
			$save_data = [
				'user' => get_user_data('id'),				'total' => $this->input->post('total'),
				'name' => $this->input->post('name'),
				'date' => $this->input->post('date'),
			];

			

			


			
			if (!is_dir(FCPATH . '/uploads/transaction/')) {
				mkdir(FCPATH . '/uploads/transaction/');
			}

			if (!empty($transaction_image_uuid)) {
				$transaction_image_name_copy = date('YmdHis') . '-' . $transaction_image_name;

				rename(FCPATH . 'uploads/tmp/' . $transaction_image_uuid . '/' . $transaction_image_name, 
						FCPATH . 'uploads/transaction/' . $transaction_image_name_copy);

				if (!is_file(FCPATH . '/uploads/transaction/' . $transaction_image_name_copy)) {
					echo json_encode([
						'success' => false,
						'message' => 'Error uploading file'
						]);
					exit;
				}

				$save_data['image'] = $transaction_image_name_copy;
			}
		
			
			$save_transaction = $this->model_transaction->change($id, $save_data);

			if ($save_transaction) {

				

				
				
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = true;
					$this->data['id'] 	   = $id;
					$this->data['message'] = cclang('success_update_data_stay', [
						admin_anchor('/transaction', ' Go back to list')
					]);
				} else {
					set_message(
						cclang('success_update_data_redirect', [
					]), 'success');

            		$this->data['success'] = true;
					$this->data['redirect'] = admin_base_url('/transaction');
				}
			} else {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = false;
					$this->data['message'] = cclang('data_not_change');
				} else {
            		$this->data['success'] = false;
            		$this->data['message'] = cclang('data_not_change');
					$this->data['redirect'] = admin_base_url('/transaction');
				}
			}
		} else {
			$this->data['success'] = false;
			$this->data['message'] = 'Opss validation failed';
			$this->data['errors'] = $this->form_validation->error_array();
		}

		$this->response($this->data);
	}
	
	/**
	* delete Transactions
	*
	* @var $id String
	*/
	public function delete($id = null)
	{
		$this->is_allowed('transaction_delete');

		$this->load->helper('file');

		$arr_id = $this->input->get('id');
		$remove = false;

		if (!empty($id)) {
			$remove = $this->_remove($id);
		} elseif (count($arr_id) >0) {
			foreach ($arr_id as $id) {
				$remove = $this->_remove($id);
			}
		}

		if ($this->input->get('ajax')) {
			if ($remove) {
				$this->response([
					"success" => true,
					"message" => cclang('has_been_deleted', 'transaction')
				]);
			} else {
				$this->response([
					"success" => true,
					"message" => cclang('error_delete', 'transaction')
				]);
			}

		} else {
			if ($remove) {
				set_message(cclang('has_been_deleted', 'transaction'), 'success');
			} else {
				set_message(cclang('error_delete', 'transaction'), 'error');
			}
			redirect_back();
		}

	}

		/**
	* View view Transactions
	*
	* @var $id String
	*/
	public function view($id)
	{
		$this->is_allowed('transaction_view');

		$this->data['transaction'] = $this->model_transaction->join_avaiable()->filter_avaiable()->find($id);

		$this->template->title('Transaction Detail');
		$this->render('backend/standart/administrator/transaction/transaction_view', $this->data);
	}
	
	/**
	* delete Transactions
	*
	* @var $id String
	*/
	private function _remove($id)
	{
		$transaction = $this->model_transaction->find($id);

		if (!empty($transaction->image)) {
			$path = FCPATH . '/uploads/transaction/' . $transaction->image;

			if (is_file($path)) {
				$delete_file = unlink($path);
			}
		}
		
		
		return $this->model_transaction->remove($id);
	}
	
	/**
	* Upload Image Transaction	* 
	* @return JSON
	*/
	public function upload_image_file()
	{
		if (!$this->is_allowed('transaction_add', false)) {
			echo json_encode([
				'success' => false,
				'message' => cclang('sorry_you_do_not_have_permission_to_access')
				]);
			exit;
		}

		$uuid = $this->input->post('qquuid');

		echo $this->upload_file([
			'uuid' 		 	=> $uuid,
			'table_name' 	=> 'transaction',
		]);
	}

	/**
	* Delete Image Transaction	* 
	* @return JSON
	*/
	public function delete_image_file($uuid)
	{
		if (!$this->is_allowed('transaction_delete', false)) {
			echo json_encode([
				'success' => false,
				'error' => cclang('sorry_you_do_not_have_permission_to_access')
				]);
			exit;
		}

		echo $this->delete_file([
            'uuid'              => $uuid, 
            'delete_by'         => $this->input->get('by'), 
            'field_name'        => 'image', 
            'upload_path_tmp'   => './uploads/tmp/',
            'table_name'        => 'transaction',
            'primary_key'       => 'id',
            'upload_path'       => 'uploads/transaction/'
        ]);
	}

	/**
	* Get Image Transaction	* 
	* @return JSON
	*/
	public function get_image_file($id)
	{
		if (!$this->is_allowed('transaction_update', false)) {
			echo json_encode([
				'success' => false,
				'message' => 'Image not loaded, you do not have permission to access'
				]);
			exit;
		}

		$transaction = $this->model_transaction->find($id);

		echo $this->get_file([
            'uuid'              => $id, 
            'delete_by'         => 'id', 
            'field_name'        => 'image', 
            'table_name'        => 'transaction',
            'primary_key'       => 'id',
            'upload_path'       => 'uploads/transaction/',
            'delete_endpoint'   => ADMIN_NAMESPACE_URL  .  '/transaction/delete_image_file'
        ]);
	}
	
	
	/**
	* Export to excel
	*
	* @return Files Excel .xls
	*/
	public function export()
	{
		$this->is_allowed('transaction_export');

		$this->model_transaction->export(
			'transaction', 
			'transaction',
			$this->model_transaction->field_search
		);
	}

	/**
	* Export to PDF
	*
	* @return Files PDF .pdf
	*/
	public function export_pdf()
	{
		$this->is_allowed('transaction_export');

		$this->model_transaction->pdf('transaction', 'transaction');
	}


	public function single_pdf($id = null)
	{
		$this->is_allowed('transaction_export');

		$table = $title = 'transaction';
		$this->load->library('HtmlPdf');
      
        $config = array(
            'orientation' => 'p',
            'format' => 'a4',
            'marges' => array(5, 5, 5, 5)
        );

        $this->pdf = new HtmlPdf($config);
        $this->pdf->setDefaultFont('stsongstdlight'); 

        $result = $this->db->get($table);
       
        $data = $this->model_transaction->find($id);
        $fields = $result->list_fields();

        $content = $this->pdf->loadHtmlPdf('core_template/pdf/pdf_single', [
            'data' => $data,
            'fields' => $fields,
            'title' => $title
        ], TRUE);

        $this->pdf->initialize($config);
        $this->pdf->pdf->SetDisplayMode('fullpage');
        $this->pdf->writeHTML($content);
        $this->pdf->Output($table.'.pdf', 'H');
	}

	
}


/* End of file transaction.php */
/* Location: ./application/controllers/administrator/Transaction.php */