<link rel="stylesheet" href="<?= BASE_ASSET ?>nestable/nesteable.css">
<link rel="stylesheet" href="<?= BASE_ASSET ?>m-switch/css/style.css">

<section class="content-header">
   <h1>
      <?= cclang('dashboard_slide') ?><small><?= cclang('list_all'); ?></small>
   </h1>
   <ol class="breadcrumb">
      <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
      <li class="active"><?= cclang('dashboard_slide') ?></li>
   </ol>
</section>
<!-- Main content -->
<section class="content">
   <div class="row">
      <div class="col-md-4">
         <div class="box box-warning">
            <div class="box-header with-border">
               <h3 class="box-title "><?= cclang('dashboard_slide'); ?></h3>
            </div>
            <div class="box-body ">

               <?php foreach (db_get_all_data('dashboard_slide') as $row) : ?>
                  <div class="menu-type-wrapper clickable  <?= $this->uri->segment(4) == url_title($row->id) ? 'active' : ''; ?>">
                     <span data-href="<?= admin_site_url('/dashboard_slide/index/' . url_title($row->id)); ?>" style="width:100% !important" class="clickable btn-block menu-type btn-group">
                        <?= _ent(ucwords($row->name)); ?>

                     </span>

                  </div>
                  <a class="m remove-data pull-right btn btn-xs">
                     <i class="fa fa-clock-o"></i> <?= $row->interval ?> s
                  </a>
                  <a class="margin-right-5 remove-data pull-right btn btn-xs btn-danger mb-2" data-href="<?= admin_base_url('/dashboard_slide/delete/' . $row->id); ?>" href="javascript:void()">
                     <i class="fa fa-trash"></i>
                  </a>
                  <a class="margin-right-5 clickable pull-right btn btn-xs btn-primary mb-2" data-href="<?= admin_base_url('/dashboard_slide/edit/' . $row->id); ?>" href="javascript:void()">
                     <i class="fa fa-edit"></i>
                  </a>
                  <a class="margin-right-5 clickable pull-right btn btn-xs btn-primary mb-2" data-href="<?= admin_base_url('/dashboard/slideshow/' . $row->id); ?>" href="javascript:void()">
                     <i class="fa fa-eye"></i>
                  </a>
               <?php endforeach; ?>
               <br>
               <a href="<?= admin_site_url('/dashboard_slide/add'); ?>" class="btn margin-top-10 btn-block btn-add btn-add-menu btn-flat" title="add menu type (Ctrl+r)"><i class="fa fa-plus-square-o"></i> <?= cclang('add_new_slide'); ?></a>
            </div>
         </div>
      </div>

      <div class="col-md-6">
         <div class="box box-warning">
            <div class="box-header with-border">
               <h3 class="box-title pull-left"><?= cclang('slide') ?> <?= ucwords(str_replace('-', ' ', $this->uri->segment(4))); ?></h3>
            </div>
            <div class="box-body ">

               <div class="menu-loading-wrap">
                  <?php if ($this->uri->segment(4)) : ?>
                     <?php is_allowed('menu_add', function () { ?>
                        <a class="btn btn-flat btn-default btn_add_new" id="btn_add_new" title="add new slide (Ctrl+a)" href="<?= admin_site_url('/dashboard_slide_item/add/' . $this->uri->segment(4)); ?>"><i class="fa fa-plus-square-o"></i> <?= cclang('add_new_button', cclang('slide')); ?></a>
                     <?php }) ?>
                  <?php endif ?>
                  <span class="loading loading-hide"><img src="<?= BASE_ASSET ?>img/loading-spin-primary.svg"> <i><?= cclang('loading_saving_data'); ?></i></span>
               </div>
               <div class="dd" id="nestable">
                  <?php
                  $menu = display_dashboard_slide_menu($this->uri->segment(4));
                  if (empty($menu)) : ?>
                     <div class="box-no-data">No data menu</div>
                  <?php else :
                     echo $menu;
                  endif; ?>
               </div>
               <div class="nestable-output"></div>
            </div>
         </div>

      </div>


   </div>
</section>
<script>
   var module_name = "dashboard_slide"
   var use_ajax_crud = false
</script>
<script src="<?= BASE_ASSET ?>js/filter.js"></script>
<script src="<?= BASE_ASSET ?>m-switch/js/jquery.mswitch.js" type="text/javascript"></script>

<script src="<?= BASE_ASSET ?>nestable/jquery.nestable.js"></script>

<script>
   $(document).ready(function() {

      "use strict";



      if (use_ajax_crud == false) {

         $(document).on('click', 'a.remove-data', function() {

            var url = $(this).attr('data-href');

            swal({
                  title: "<?= cclang('are_you_sure'); ?>",
                  text: "<?= cclang('data_to_be_deleted_can_not_be_restored'); ?>",
                  type: "warning",
                  showCancelButton: true,
                  confirmButtonColor: "#DD6B55",
                  confirmButtonText: "<?= cclang('yes_delete_it'); ?>",
                  cancelButtonText: "<?= cclang('no_cancel_plx'); ?>",
                  closeOnConfirm: true,
                  closeOnCancel: true
               },
               function(isConfirm) {
                  if (isConfirm) {
                     document.location.href = url;
                  }
               });

            return false;
         });
      }



      $(document).on('click', '#apply', function() {

         var bulk = $('#bulk');
         var serialize_bulk = $('#form_dashboard_slide').serialize();

         if (bulk.val() == 'delete') {
            swal({
                  title: "<?= cclang('are_you_sure'); ?>",
                  text: "<?= cclang('data_to_be_deleted_can_not_be_restored'); ?>",
                  type: "warning",
                  showCancelButton: true,
                  confirmButtonColor: "#DD6B55",
                  confirmButtonText: "<?= cclang('yes_delete_it'); ?>",
                  cancelButtonText: "<?= cclang('no_cancel_plx'); ?>",
                  closeOnConfirm: true,
                  closeOnCancel: true
               },
               function(isConfirm) {
                  if (isConfirm) {
                     document.location.href = ADMIN_BASE_URL + '/dashboard_slide/delete?' + serialize_bulk;
                  }
               });

            return false;

         } else if (bulk.val() == '') {
            swal({
               title: "Upss",
               text: "<?= cclang('please_choose_bulk_action_first'); ?>",
               type: "warning",
               showCancelButton: false,
               confirmButtonColor: "#DD6B55",
               confirmButtonText: "Okay!",
               closeOnConfirm: true,
               closeOnCancel: true
            });

            return false;
         }

         return false;

      }); /*end appliy click*/


      //check all
      var checkAll = $('#check_all');
      var checkboxes = $('input.check');

      checkAll.on('ifChecked ifUnchecked', function(event) {
         if (event.type == 'ifChecked') {
            checkboxes.iCheck('check');
         } else {
            checkboxes.iCheck('uncheck');
         }
      });

      checkboxes.on('ifChanged', function(event) {
         if (checkboxes.filter(':checked').length == checkboxes.length) {
            checkAll.prop('checked', 'checked');
         } else {
            checkAll.removeProp('checked');
         }
         checkAll.iCheck('update');
      });
      initSortableAjax('dashboard_slide', $('table.dataTable'));


      var timeout;
      $('.dd').on('change', function() {
         clearTimeout(timeout);
         timeout = setTimeout(updateOrderMenu, 2000);
      });

      function updateOrderMenu(ignoreMessage) {
         $('.loading').removeClass('loading-hide');
         var shownotif = true;
         var menu = $('.dd').nestable('serialize');

         if (typeof shownotif == 'undefined') {
            var shownotif = true;
         }

         if (typeof ignoreMessage == 'undefined') {
            var ignoreMessage = false;
         }

         var data = {};
         data['menu'] = menu
         data[csrf] = token

         $.ajax({
               url: ADMIN_BASE_URL + '/dashboard_slide/save_ordering',
               type: 'POST',
               dataType: 'JSON',
               data: data,
            })
            .done(function(res) {
               if (res.success) {
                  $('.sidebar-menu').html(res.menu);
                  if (shownotif) {
                     if (!ignoreMessage) {
                        toastr['success'](res.message);
                     }
                  }
               } else {
                  if (shownotif) {
                     if (!ignoreMessage) {
                        toastr['warning'](res.message);
                     }
                  }
               }
            })
            .fail(function() {
               if (!ignoreMessage) {
                  toastr['warning']('Error save data please try again later');
               }
            })
            .always(function() {
               $('.loading').addClass('loading-hide');
            });
      }

      $('#nestable').nestable({
         group: 1,
         axis: "y", // Allow vertical sorting
      });

      $('.clickable').on('click', function() {
         var href = $(this).attr('data-href');

         window.location.href = href;

         return false;
      }); /*end clickable click*/

      $(".m_switch_check:checkbox").mSwitch({
         onRender: function(elem) {
            changeSharingDashboard(elem.val(), 'dont_update');
            if (elem.val() == 0) {
               $.mSwitch.turnOff(elem);
            } else {
               $.mSwitch.turnOn(elem);
            }
         },
         onTurnOn: function(elem) {
            changeSharingDashboard(1, 'update');
         },
         onTurnOff: function(elem) {
            changeSharingDashboard(0, 'update');
         }
      });

      function setMenuActive(id, status) {
         var data = [];

         data.push({
            name: csrf,
            value: token
         });
         data.push({
            name: 'status',
            value: status
         });
         data.push({
            name: 'id',
            value: id
         });

         $.ajax({
               url: ADMIN_BASE_URL + '/menu/set_status',
               type: 'POST',
               dataType: 'JSON',
               data: data,
            })
            .done(function(data) {
               if (data.success) {
                  toastr['success'](data.message);
                  updateOrderMenu(true)
               } else {
                  toastr['warning'](data.message);
               }

            })
            .fail(function() {
               toastr['error']('Error update status');
            });
      }


      $('.menu-toggle-activate').dblclick(function(event) {
         event.stopPropagation();
         var status = $(this).data('status');
         var id = $(this).data('id');

         switch (status) {
            case undefined:
            case 0:
               $(this).removeClass('menu-toggle-activate_inactive');
               $(this).data('status', 1)
               setMenuActive(id, 1);
               break;
            case 1:
               $(this).addClass('menu-toggle-activate_inactive');
               $(this).data('status', 0)
               setMenuActive(id, 0);
               break;
         }
      });

      $('.dd3-item').on('mouseover', function() {
         $('.dropdown').removeClass('open')

         $(this).find('.dropdown:first').addClass('open')
      });
   }); /*end doc ready*/
</script>