<?php

use Symfony\Component\VarDumper\VarDumper;

defined('BASEPATH') or exit('No direct script access allowed');


/**
 *| --------------------------------------------------------------------------
 *| Dashboard Controller
 *| --------------------------------------------------------------------------
 *| For see your board
 *|
 */
class Dashboard extends Admin
{

	public function __construct()
	{
		parent::__construct();
		$this->load->model('model_dashboard');
		$this->load->model('widged/model_widged');
		$this->load->library('widged/cc_widged');
	}

	public function index()
	{
		if (!$this->aauth->is_allowed('dashboard')) {
			redirect('/', 'refresh');
		}
		$dashboards = $this->model_dashboard->get(null, null, $limit = 9999, $offset = 0);
		$data = [
			'dashboards' => $dashboards
		];
		$this->render('backend/standart/dashboard', $data);
	}

	public function slideshow($slide_id = null)
	{
		$data = [];
		$data['config'] = $this->db->get_where('dashboard_slide', ['id' => $slide_id])->row();
		$this->db->join('dashboard', 'dashboard.id = dashboard_slide_item.dashboard_id', 'LEFT');
		$data['slides'] = $this->db->order_by('dashboard_slide_item.sort_order', 'asc')->get_where('dashboard_slide_item', ['dashboard_slide_id' => $slide_id])->result();

		$this->render('backend/standart/dashboard_slideshow', $data);
	}

	public function edit($slug = null)
	{
		if (!$this->aauth->is_allowed('dashboard_update')) {
			redirect('/', 'refresh');
		}

		$dashboard = $this->model_dashboard->find_by_slug($slug);
		if (!$dashboard) {
			redirect(ADMIN_NAMESPACE_URL . '/dashboard', 'refresh');
		}

		$widgeds = $this->model_widged->find_by_dashboard_id($dashboard->id);
		$data = [
			'dashboard' => $dashboard,
			'widgeds' => $widgeds,
			'slug' => $slug,
			'edit' => true

		];
		$this->render('backend/standart/administrator/dashboard_add', $data);
	}


	public function setting($slug = null)
	{
		if (!$this->aauth->is_allowed('dashboard_update')) {
			redirect('/', 'refresh');
		}

		$dashboard = $this->model_dashboard->find_by_slug($slug);
		if (!$dashboard) {
			redirect(ADMIN_NAMESPACE_URL . '/dashboard', 'refresh');
		}

		$data = [
			'dashboard' => $dashboard,
		];
		$this->load->view('backend/standart/administrator/dashboard_setting', $data);
	}


	public function show($slug = null)
	{
		if (!$this->aauth->is_allowed('dashboard')) {
			redirect('/', 'refresh');
		}

		$dashboard = $this->model_dashboard->find_by_slug($slug);
		if (!$dashboard) {
			redirect(ADMIN_NAMESPACE_URL . '/dashboard', 'refresh');
		}

		$widgeds = $this->model_widged->find_by_dashboard_id($dashboard->id);
		$data = [
			'dashboard' => $dashboard,
			'widgeds' => $widgeds,
			'slug' => $slug,
			'edit' => false
		];
		$this->render('backend/standart/administrator/dashboard_add', $data);
	}

	public function remove($slug = null)
	{
		if (!$this->aauth->is_allowed('dashboard')) {
			redirect('/', 'refresh');
		}

		$dashboard = $this->model_dashboard->find_by_slug($slug);
		if (!$dashboard) {
			redirect(ADMIN_NAMESPACE_URL . '/dashboard', 'refresh');
		}
		$remove = $this->model_dashboard->remove($dashboard->id);
		if ($remove) {
			set_message(cclang('has_been_deleted', 'Dashboard'), 'success');
		} else {
			set_message(cclang('error_delete', 'Dashboard'), 'error');
		}
		redirect(ADMIN_NAMESPACE_URL . '/dashboard', 'refresh');
	}


	public function add_to_slide()
	{
		if (!$this->aauth->is_allowed('dashboard')) {
			redirect('/', 'refresh');
		}

		$this->load->model('dashboard_slide_item/model_dashboard_slide_item');


		$dashboard = $this->model_dashboard->find($this->input->post('dashboard_id'));
		if (!$dashboard and !$this->input->post('slide_id')) {
			redirect(ADMIN_NAMESPACE_URL . '/dashboard', 'refresh');
		}

		$save_data = [
			'dashboard_slide_id' =>  $this->input->post('slide_id'),
			'dashboard_id' => $this->input->post('dashboard_id'),
			'sort_order' => 1,
		];


		$save_dashboard_slide_item = $id = $this->model_dashboard_slide_item->store($save_data);


		if ($save_dashboard_slide_item) {
			set_message('Dashboard added to slide', 'success');
		} else {
			set_message(cclang('error', 'Dashboard'), 'error');
		}
		redirect(ADMIN_NAMESPACE_URL . '/dashboard', 'refresh');
	}


	public function loadWidged($type = null)
	{
		$lib = 'Widged_' . $type;
		list($path, $_library) = Modules::find($lib, $type, '/');
		require_once($path . $lib . '.' . 'php');
		$this->load->library($lib);
		$ccWidged = $this->cc_widged->setWidgedInstance($this->{strtolower($lib)});

		return $this->cc_widged->instance;
	}


	public function duplicate($slug = null)
	{
		$this->load->helper('string');
		if (!$this->aauth->is_allowed('dashboard')) {
			redirect('/', 'refresh');
		}

		$dashboard = $this->model_dashboard->find_by_slug($slug);
		if (!$dashboard) {
			redirect(ADMIN_NAMESPACE_URL . '/dashboard', 'refresh');
		}

		$id = $dashboard->id;

		$widgeds = $this->model_widged->find_by_dashboard_id($id);


		unset($dashboard->id);
		$dashboard->title = $dashboard->title . ' (copy)';
		$dashboard->slug = $dashboard->slug . '-2' . random_string();
		$dashboard = (array) $dashboard;

		$id = $this->model_dashboard->store($dashboard);

		if ($id) {
			foreach ($widgeds as $wg) {

				$type = $wg->widged_type;
				$instance = $this->loadWidged($type);

				$widged = app()->db->get_where('widgeds', ['id' => $wg->id])->row();
				$widged_id = $widged->id;
				$widged->widged_uuid = md5(random_string() . random_string());
				unset($widged->id);
				$widged->title = $widged->title;
				$widged->dashboard_id = $id;

				$insert = app()->db->insert('widgeds', (array)$widged);

				$new_widged_id = $this->db->insert_id();


				$child = app()->db->get_where($instance->table_name, ['widged_id' => $wg->id])->row();


				unset($child->id);
				$child->widged_id = $new_widged_id;


				$insert = $this->db->insert($instance->table_name, (array) $child);

				$error = $this->db->error();


				if (method_exists($instance, 'afterDuplicate')) {
					$instance->afterDuplicate([
						'id' => $widged_id,
						'new_id' => $new_widged_id,
					]);
				}
			}
			set_message('Dashboard duplicated', 'success');
		} else {
			set_message('Error duplicate', 'error');
		}

		$widgeds = app()->db->get_where('widgeds', ['id' => $id])->result();

		redirect(ADMIN_NAMESPACE_URL . '/dashboard/edit/' . $dashboard['slug'], 'refresh');
	}

	public function create()
	{
		if (!$this->aauth->is_allowed('dashboard')) {
			redirect('/', 'refresh');
		}

		$name = $this->input->get('name');

		$id = $this->model_dashboard->store([
			'title' => $name,
			'created_at' => now()
		]);

		$slug = $id . '-' . url_title($name);

		$this->model_dashboard->change($id, [
			'slug' => $slug
		]);

		redirect(ADMIN_NAMESPACE_URL . '/dashboard/edit/' . $slug, 'refresh');
	}


	public function change_title()
	{
		if (!$this->aauth->is_allowed('dashboard')) {
			redirect('/', 'refresh');
		}

		$id = $this->input->get('id');
		$title = $this->input->get('title');

		$id = $this->model_dashboard->change($id, [
			'title' => $title
		]);
	}


	public function change_icon()
	{
		if (!$this->aauth->is_allowed('dashboard')) {
			redirect('/', 'refresh');
		}

		$id = $this->input->get('id');

		$data = [];

		if ($this->input->get('color')) {
			$data['color'] = $this->input->get('color');
		}

		if ($this->input->get('icon')) {
			$data['icon'] = $this->input->get('icon');
		}

		$id = $this->model_dashboard->change($id, $data);
	}

	public function save_reorder()
	{
		$save_data = [];

		foreach ($_POST['dashboards'] as $id => $sort_number) {

			$save_data[] = [
				'id' => $id,
				'sort_order' => $sort_number,
			];
		}

		$this->db->update_batch('dashboard', $save_data, 'id');

		$this->response([
			'status' => true,
			'message' => cclang('dashboard_reordered')
		]);
	}

	public function findDashboardPage($slug, $type)
	{
		$table = 'dashboard';

		$currentDashboard = $this->db->get_where($table, ['slug' => $slug])->row();
		$page = $this->input->get('p');

		if ($type == 'next') {
			$opr = '>';
		}

		if ($type == 'prev') {
			$opr = '<';
		}

		if ($currentDashboard) {
			$nextDashboard = $this->db->select('*')
				->from($table)
				->where('sort_order ' . $opr, $currentDashboard->sort_order)
				->order_by('sort_order', 'asc')
				->limit(1)
				->get()
				->row();

			if ($nextDashboard) {
				redirect(ADMIN_NAMESPACE_URL . '/dashboard/' . $page . '/' . $nextDashboard->slug, 'refresh');
			} else {
				$firstDashboard = $this->db->select('*')
					->from($table)
					->order_by('sort_order', $type == 'next' ? 'asc' : 'desc')
					->limit(1)
					->get()
					->row();

				if ($firstDashboard) {
					redirect(ADMIN_NAMESPACE_URL . '/dashboard/' . $page . '/' . $firstDashboard->slug, 'refresh');
				} else {
					redirect(ADMIN_NAMESPACE_URL . '/dashboard', 'refresh');
				}
			}
		} else {
			redirect(ADMIN_NAMESPACE_URL . '/dashboard', 'refresh');
		}
	}


	public function next($slug = null)
	{
		if (!$this->aauth->is_allowed('dashboard')) {
			redirect('/', 'refresh');
		}

		$this->findDashboardPage($slug, 'next');
	}

	public function prev($slug = null)
	{
		if (!$this->aauth->is_allowed('dashboard')) {
			redirect('/', 'refresh');
		}

		$this->findDashboardPage($slug, 'prev');
	}


	/**
	 * Update groups
	 *
	 * @var $id String
	 */
	public function setting_save($slug)
	{
		if (!$this->is_allowed('dashboard_update', false)) {
			return $this->response([
				'success' => false,
				'message' => cclang('sorry_you_do_not_have_permission_to_access')
			]);
		}

		if (!$this->aauth->is_allowed('dashboard_update')) {
			redirect('/', 'refresh');
		}

		$dashboard = $this->model_dashboard->find_by_slug($slug);

		if (!$dashboard) {
			redirect(ADMIN_NAMESPACE_URL . '/dashboard', 'refresh');
		}

		$this->form_validation->set_rules('title_color', 'Name', 'trim|required');

		if ($this->form_validation->run()) {

			$save_data = [
				'title_color' 		=> $this->input->post('title_color'),
				'title_bg_color' 	=> $this->input->post('title_bg_color'),
				'icon_color' 		=> $this->input->post('icon_color'),
			];

			$save_group = $this->model_dashboard->change($dashboard->id, $save_data);


			$this->data['dashboard'] = $save_data;
			$this->data['success'] = true;
			$this->data['redirect'] = admin_base_url('/dashboard/edit/' . $dashboard->slug);
		} else {
			$this->data['success'] = false;
			$this->data['message'] = validation_errors();
		}

		return $this->response($this->data);
	}
}

/* End of file Dashboard.php */
/* Location: ./application/controllers/administrator/Dashboard.php */