<?php
defined('BASEPATH') or exit('No direct script access allowed');


/**
 *| --------------------------------------------------------------------------
 *| Dashboard Slide Item Controller
 *| --------------------------------------------------------------------------
 *| Dashboard Slide Item site
 *|
 */
class Dashboard_slide_item extends Admin
{

	public function __construct()
	{
		parent::__construct();

		$this->load->model('model_dashboard_slide_item');
		$this->load->model('group/model_group');
		$this->lang->load('web_lang', $this->current_lang);
	}

	/**
	 * show all Dashboard Slide Items
	 *
	 * @var $offset String
	 */
	public function index($offset = 0)
	{
		$this->is_allowed('dashboard_slide_item_list');

		$filter = $this->input->get('q');
		$field 	= $this->input->get('f');

		$this->data['dashboard_slide_items'] = $this->model_dashboard_slide_item->get($filter, $field, $this->limit_page, $offset);
		$this->data['dashboard_slide_item_counts'] = $this->model_dashboard_slide_item->count_all($filter, $field);

		$config = [
			'base_url'     => ADMIN_NAMESPACE_URL  . '/dashboard_slide_item/index/',
			'total_rows'   => $this->data['dashboard_slide_item_counts'],
			'per_page'     => $this->limit_page,
			'uri_segment'  => 4,
		];

		$this->data['pagination'] = $this->pagination($config);

		$this->data['tables'] = $this->load->view('backend/standart/administrator/dashboard_slide_item/dashboard_slide_item_data_table', $this->data, true);

		if ($this->input->get('ajax')) {
			$this->response([
				'tables' => $this->data['tables'],
				'pagination' => $this->data['pagination'],
				'total_row' => $this->data['dashboard_slide_item_counts']
			]);
		}

		$this->template->title('Dashboard Slide Item List');
		$this->render('backend/standart/administrator/dashboard_slide_item/dashboard_slide_item_list', $this->data);
	}

	/**
	 * Add new dashboard_slide_items
	 *
	 */
	public function add()
	{
		$this->is_allowed('dashboard_slide_item_add');

		$this->template->title('Dashboard Slide Item New');
		$this->render('backend/standart/administrator/dashboard_slide_item/dashboard_slide_item_add', $this->data);
	}

	/**
	 * Add New Dashboard Slide Items
	 *
	 * @return JSON
	 */
	public function add_save()
	{
		if (!$this->is_allowed('dashboard_slide_item_add', false)) {
			echo json_encode([
				'success' => false,
				'message' => cclang('sorry_you_do_not_have_permission_to_access')
			]);
			exit;
		}


		$this->form_validation->set_rules('dashboard_id', 'Dahboard Id', 'trim|required');



		if ($this->form_validation->run()) {

			$save_data = [
				'dashboard_slide_id' => $this->uri->segment(4),
				'dashboard_id' => $this->input->post('dashboard_id'),
				'sort_order' => 1,
			];


			$save_dashboard_slide_item = $id = $this->model_dashboard_slide_item->store($save_data);


			if ($save_dashboard_slide_item) {
				set_message(
					cclang('success_save_data_redirect', [
						admin_anchor('/dashboard_slide/index/' . $this->uri->segment(4), 'Edit Dashboard Slide Item')
					]),
					'success'
				);

				$this->data['success'] = true;
				$this->data['redirect'] = admin_base_url('/dashboard_slide/index/' . $this->uri->segment(4));
			} else {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = false;
					$this->data['message'] = cclang('data_not_change');
				} else {
					$this->data['success'] = false;
					$this->data['message'] = cclang('data_not_change');
					$this->data['redirect'] = admin_base_url('/dashboard_slide_item');
				}
			}
		} else {
			$this->data['success'] = false;
			$this->data['message'] = 'Opss validation failed';
			$this->data['errors'] = $this->form_validation->error_array();
		}

		$this->response($this->data);
	}

	/**
	 * Update view Dashboard Slide Items
	 *
	 * @var $id String
	 */
	public function edit($id)
	{
		$this->is_allowed('dashboard_slide_item_update');

		$this->data['dashboard_slide_item'] = $this->model_dashboard_slide_item->find($id);

		$this->template->title('Dashboard Slide Item Update');
		$this->render('backend/standart/administrator/dashboard_slide_item/dashboard_slide_item_update', $this->data);
	}

	/**
	 * Update Dashboard Slide Items
	 *
	 * @var $id String
	 */
	public function edit_save($id)
	{
		if (!$this->is_allowed('dashboard_slide_item_update', false)) {
			echo json_encode([
				'success' => false,
				'message' => cclang('sorry_you_do_not_have_permission_to_access')
			]);
			exit;
		}

		$this->form_validation->set_rules('dashboard_id', 'Dahboard Id', 'trim|required');



		if ($this->form_validation->run()) {

			$save_data = [
				'dashboard_slide_id' => $this->input->post('dashboard_slide_id'),
				'dashboard_id' => $this->input->post('dashboard_id'),
				'sort_order' => $this->input->post('sort_order'),
			];








			$save_dashboard_slide_item = $this->model_dashboard_slide_item->change($id, $save_data);

			if ($save_dashboard_slide_item) {





				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = true;
					$this->data['id'] 	   = $id;
					$this->data['message'] = cclang('success_update_data_stay', [
						admin_anchor('/dashboard_slide_item', ' Go back to list')
					]);
				} else {
					set_message(
						cclang('success_update_data_redirect', []),
						'success'
					);

					$this->data['success'] = true;
					$this->data['redirect'] = admin_base_url('/dashboard_slide_item');
				}
			} else {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = false;
					$this->data['message'] = cclang('data_not_change');
				} else {
					$this->data['success'] = false;
					$this->data['message'] = cclang('data_not_change');
					$this->data['redirect'] = admin_base_url('/dashboard_slide_item');
				}
			}
		} else {
			$this->data['success'] = false;
			$this->data['message'] = 'Opss validation failed';
			$this->data['errors'] = $this->form_validation->error_array();
		}

		$this->response($this->data);
	}

	/**
	 * delete Dashboard Slide Items
	 *
	 * @var $id String
	 */
	public function delete($id = null)
	{
		$this->is_allowed('dashboard_slide_item_delete');

		$this->load->helper('file');

		$arr_id = $this->input->get('id');
		$remove = false;

		if (!empty($id)) {
			$remove = $this->_remove($id);
		} elseif (count($arr_id) > 0) {
			foreach ($arr_id as $id) {
				$remove = $this->_remove($id);
			}
		}

		if ($this->input->get('ajax')) {
			if ($remove) {
				$this->response([
					"success" => true,
					"message" => cclang('has_been_deleted', 'dashboard_slide_item')
				]);
			} else {
				$this->response([
					"success" => true,
					"message" => cclang('error_delete', 'dashboard_slide_item')
				]);
			}
		} else {
			if ($remove) {
				set_message(cclang('has_been_deleted', 'dashboard_slide_item'), 'success');
			} else {
				set_message(cclang('error_delete', 'dashboard_slide_item'), 'error');
			}
			redirect_back();
		}
	}

	/**
	 * View view Dashboard Slide Items
	 *
	 * @var $id String
	 */
	public function view($id)
	{
		$this->is_allowed('dashboard_slide_item_view');

		$this->data['dashboard_slide_item'] = $this->model_dashboard_slide_item->join_avaiable()->filter_avaiable()->find($id);

		$this->template->title('Dashboard Slide Item Detail');
		$this->render('backend/standart/administrator/dashboard_slide_item/dashboard_slide_item_view', $this->data);
	}

	/**
	 * delete Dashboard Slide Items
	 *
	 * @var $id String
	 */
	private function _remove($id)
	{
		$dashboard_slide_item = $this->model_dashboard_slide_item->find($id);



		return $this->model_dashboard_slide_item->remove($id);
	}


	/**
	 * Export to excel
	 *
	 * @return Files Excel .xls
	 */
	public function export()
	{
		$this->is_allowed('dashboard_slide_item_export');

		$this->model_dashboard_slide_item->export(
			'dashboard_slide_item',
			'dashboard_slide_item',
			$this->model_dashboard_slide_item->field_search
		);
	}

	/**
	 * Export to PDF
	 *
	 * @return Files PDF .pdf
	 */
	public function export_pdf()
	{
		$this->is_allowed('dashboard_slide_item_export');

		$this->model_dashboard_slide_item->pdf('dashboard_slide_item', 'dashboard_slide_item');
	}


	public function single_pdf($id = null)
	{
		$this->is_allowed('dashboard_slide_item_export');

		$table = $title = 'dashboard_slide_item';
		$this->load->library('HtmlPdf');

		$config = array(
			'orientation' => 'p',
			'format' => 'a4',
			'marges' => array(5, 5, 5, 5)
		);

		$this->pdf = new HtmlPdf($config);
		$this->pdf->setDefaultFont('stsongstdlight');

		$result = $this->db->get($table);

		$data = $this->model_dashboard_slide_item->find($id);
		$fields = $result->list_fields();

		$content = $this->pdf->loadHtmlPdf('core_template/pdf/pdf_single', [
			'data' => $data,
			'fields' => $fields,
			'title' => $title
		], TRUE);

		$this->pdf->initialize($config);
		$this->pdf->pdf->SetDisplayMode('fullpage');
		$this->pdf->writeHTML($content);
		$this->pdf->Output($table . '.pdf', 'H');
	}
}


/* End of file dashboard_slide_item.php */
/* Location: ./application/controllers/administrator/Dashboard Slide Item.php */