<?php
defined('BASEPATH') or exit('No direct script access allowed');


/**
 *| --------------------------------------------------------------------------
 *| Dashboard Slide Controller
 *| --------------------------------------------------------------------------
 *| Dashboard Slide site
 *|
 */
class Dashboard_slide extends Admin
{

	public $menus = [];
	public $sort = 0;

	public function __construct()
	{
		parent::__construct();

		$this->load->model('model_dashboard_slide');
		$this->load->model('dashboard_slide_item/model_dashboard_slide_item');
		$this->load->model('group/model_group');
		$this->lang->load('web_lang', $this->current_lang);
	}

	/**
	 * show all Dashboard Slides
	 *
	 * @var $offset String
	 */
	public function index($active = 0)
	{
		$this->is_allowed('dashboard_slide_list');

		$filter = $this->input->get('q');
		$field 	= $this->input->get('f');

		if (!$active) {
			$slide = $this->db->order_by('id', 'ASC')->get('dashboard_slide')->row();

			if ($slide) {
				redirect(admin_url('dashboard_slide/index/' . $slide->id));
			} else {
				redirect(admin_url('dashboard_slide/add/'));
			}
		}

		$this->limit_page = 99999;

		$offset = 0;

		$this->data['dashboard_slides'] = $this->model_dashboard_slide->get($filter, $field, $this->limit_page, $offset);
		$this->data['dashboard_slide_items'] = $this->model_dashboard_slide_item->get($filter, $field, 99999, $offset);
		$this->data['dashboard_slide_counts'] = $this->model_dashboard_slide->count_all($filter, $field);

		$config = [
			'base_url'     => ADMIN_NAMESPACE_URL  . '/dashboard_slide/index/',
			'total_rows'   => $this->data['dashboard_slide_counts'],
			'per_page'     => $this->limit_page,
			'uri_segment'  => 4,
		];

		$this->data['pagination'] = $this->pagination($config);

		$this->data['tables'] = $this->load->view('backend/standart/administrator/dashboard_slide/dashboard_slide_data_table', $this->data, true);

		if ($this->input->get('ajax')) {
			$this->response([
				'tables' => $this->data['tables'],
				'pagination' => $this->data['pagination'],
				'total_row' => $this->data['dashboard_slide_counts']
			]);
		}

		$this->template->title('Dashboard Slide List');
		$this->render('backend/standart/administrator/dashboard_slide/dashboard_slide_list', $this->data);
	}

	/**
	 * Add new dashboard_slides
	 *
	 */
	public function add()
	{
		$this->is_allowed('dashboard_slide_add');

		$this->template->title('Dashboard Slide New');
		$this->render('backend/standart/administrator/dashboard_slide/dashboard_slide_add', $this->data);
	}

	/**
	 * Add New Dashboard Slides
	 *
	 * @return JSON
	 */
	public function add_save()
	{
		if (!$this->is_allowed('dashboard_slide_add', false)) {
			echo json_encode([
				'success' => false,
				'message' => cclang('sorry_you_do_not_have_permission_to_access')
			]);
			exit;
		}



		$this->form_validation->set_rules('name', 'Name', 'trim|required');


		$this->form_validation->set_rules('interval', 'Interval', 'trim|required');




		if ($this->form_validation->run()) {

			$save_data = [
				'name' => $this->input->post('name'),
				'interval' => $this->input->post('interval'),
			];

			$save_dashboard_slide = $id = $this->model_dashboard_slide->store($save_data);

			if ($save_dashboard_slide) {

				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = true;
					$this->data['id'] 	   = $save_dashboard_slide;
					$this->data['message'] = cclang('success_save_data_stay', [
						admin_anchor('/dashboard_slide/edit/' . $save_dashboard_slide, 'Edit Dashboard Slide'),
						admin_anchor('/dashboard_slide', ' Go back to list')
					]);
				} else {
					set_message(
						cclang('success_save_data_redirect', [
							admin_anchor('/dashboard_slide/edit/' . $save_dashboard_slide, 'Edit Dashboard Slide')
						]),
						'success'
					);

					$this->data['success'] = true;
					$this->data['redirect'] = admin_base_url('/dashboard_slide');
				}
			} else {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = false;
					$this->data['message'] = cclang('data_not_change');
				} else {
					$this->data['success'] = false;
					$this->data['message'] = cclang('data_not_change');
					$this->data['redirect'] = admin_base_url('/dashboard_slide');
				}
			}
		} else {
			$this->data['success'] = false;
			$this->data['message'] = 'Opss validation failed';
			$this->data['errors'] = $this->form_validation->error_array();
		}

		$this->response($this->data);
	}

	/**
	 * Update view Dashboard Slides
	 *
	 * @var $id String
	 */
	public function edit($id)
	{
		$this->is_allowed('dashboard_slide_update');

		$this->data['dashboard_slide'] = $this->model_dashboard_slide->find($id);

		$this->template->title('Dashboard Slide Update');
		$this->render('backend/standart/administrator/dashboard_slide/dashboard_slide_update', $this->data);
	}

	/**
	 * Update Dashboard Slides
	 *
	 * @var $id String
	 */
	public function edit_save($id)
	{
		if (!$this->is_allowed('dashboard_slide_update', false)) {
			echo json_encode([
				'success' => false,
				'message' => cclang('sorry_you_do_not_have_permission_to_access')
			]);
			exit;
		}
		$this->form_validation->set_rules('name', 'Name', 'trim|required');


		$this->form_validation->set_rules('interval', 'Interval', 'trim|required');



		if ($this->form_validation->run()) {

			$save_data = [
				'name' => $this->input->post('name'),
				'interval' => $this->input->post('interval'),
			];








			$save_dashboard_slide = $this->model_dashboard_slide->change($id, $save_data);

			if ($save_dashboard_slide) {





				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = true;
					$this->data['id'] 	   = $id;
					$this->data['message'] = cclang('success_update_data_stay', [
						admin_anchor('/dashboard_slide', ' Go back to list')
					]);
				} else {
					set_message(
						cclang('success_update_data_redirect', []),
						'success'
					);

					$this->data['success'] = true;
					$this->data['redirect'] = admin_base_url('/dashboard_slide');
				}
			} else {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = false;
					$this->data['message'] = cclang('data_not_change');
				} else {
					$this->data['success'] = false;
					$this->data['message'] = cclang('data_not_change');
					$this->data['redirect'] = admin_base_url('/dashboard_slide');
				}
			}
		} else {
			$this->data['success'] = false;
			$this->data['message'] = 'Opss validation failed';
			$this->data['errors'] = $this->form_validation->error_array();
		}

		$this->response($this->data);
	}

	/**
	 * delete Dashboard Slides
	 *
	 * @var $id String
	 */
	public function delete($id = null)
	{
		$this->is_allowed('dashboard_slide_delete');

		$this->load->helper('file');

		$arr_id = $this->input->get('id');
		$remove = false;

		if (!empty($id)) {
			$remove = $this->_remove($id);
		} elseif (count($arr_id) > 0) {
			foreach ($arr_id as $id) {
				$remove = $this->_remove($id);
			}
		}

		if ($this->input->get('ajax')) {
			if ($remove) {
				$this->response([
					"success" => true,
					"message" => cclang('has_been_deleted', 'dashboard_slide')
				]);
			} else {
				$this->response([
					"success" => true,
					"message" => cclang('error_delete', 'dashboard_slide')
				]);
			}
		} else {
			if ($remove) {
				set_message(cclang('has_been_deleted', 'dashboard_slide'), 'success');
			} else {
				set_message(cclang('error_delete', 'dashboard_slide'), 'error');
			}
			redirect_back();
		}
	}

	/**
	 * View view Dashboard Slides
	 *
	 * @var $id String
	 */
	public function view($id)
	{
		$this->is_allowed('dashboard_slide_view');

		$this->data['dashboard_slide'] = $this->model_dashboard_slide->join_avaiable()->filter_avaiable()->find($id);

		$this->template->title('Dashboard Slide Detail');
		$this->render('backend/standart/administrator/dashboard_slide/dashboard_slide_view', $this->data);
	}

	/**
	 * delete Dashboard Slides
	 *
	 * @var $id String
	 */
	private function _remove($id)
	{
		$dashboard_slide = $this->model_dashboard_slide->find($id);



		return $this->model_dashboard_slide->remove($id);
	}



	/**
	 * save ordering menus
	 *
	 * @var $id String
	 */
	public function save_ordering()
	{
		if (!$this->is_allowed('menu_save_ordering', false)) {
			return $this->response([
				'success' => false,
				'message' => cclang('sorry_you_do_not_have_permission_to_access')
			]);
		}

		$this->menus = [];
		$this->sort = 0;
		$this->_parse_menu($_POST['menu']);
		$save_ordering = $this->db->update_batch('dashboard_slide_item', $this->menus, 'id');
		if ($save_ordering) {
			$this->data = [
				'success' => true,
				'message' => cclang('success_save_data_stay'),
			];
		} else {
			$this->data = [
				'success' => false,
				'message' => cclang('data_not_change')
			];
		}

		return $this->response($this->data);
	}


	/**
	 * parse menu
	 *
	 * @var $menu array
	 */
	private function _parse_menu($menus)
	{
		$data = [];
		foreach ($menus as $menu) {
			$this->sort++;
			$this->menus[] = [
				'id' => $menu['id'],
				'sort_order' => $this->sort
			];
		}
	}



	/**
	 * Export to excel
	 *
	 * @return Files Excel .xls
	 */
	public function export()
	{
		$this->is_allowed('dashboard_slide_export');

		$this->model_dashboard_slide->export(
			'dashboard_slide',
			'dashboard_slide',
			$this->model_dashboard_slide->field_search
		);
	}

	/**
	 * Export to PDF
	 *
	 * @return Files PDF .pdf
	 */
	public function export_pdf()
	{
		$this->is_allowed('dashboard_slide_export');

		$this->model_dashboard_slide->pdf('dashboard_slide', 'dashboard_slide');
	}


	public function single_pdf($id = null)
	{
		$this->is_allowed('dashboard_slide_export');

		$table = $title = 'dashboard_slide';
		$this->load->library('HtmlPdf');

		$config = array(
			'orientation' => 'p',
			'format' => 'a4',
			'marges' => array(5, 5, 5, 5)
		);

		$this->pdf = new HtmlPdf($config);
		$this->pdf->setDefaultFont('stsongstdlight');

		$result = $this->db->get($table);

		$data = $this->model_dashboard_slide->find($id);
		$fields = $result->list_fields();

		$content = $this->pdf->loadHtmlPdf('core_template/pdf/pdf_single', [
			'data' => $data,
			'fields' => $fields,
			'title' => $title
		], TRUE);

		$this->pdf->initialize($config);
		$this->pdf->pdf->SetDisplayMode('fullpage');
		$this->pdf->writeHTML($content);
		$this->pdf->Output($table . '.pdf', 'H');
	}
}


/* End of file dashboard_slide.php */
/* Location: ./application/controllers/administrator/Dashboard Slide.php */