<?php
defined('BASEPATH') OR exit('No direct script access allowed');


/**
*| --------------------------------------------------------------------------
*| Chat Contact Controller
*| --------------------------------------------------------------------------
*| Chat Contact site
*|
*/
class Chat_contact extends Admin	
{
	
	public function __construct()
	{
		parent::__construct();

		$this->load->model('model_chat_contact');
		$this->load->model('group/model_group');
		$this->lang->load('web_lang', $this->current_lang);
	}

	/**
	* show all Chat Contacts
	*
	* @var $offset String
	*/
	public function index($offset = 0)
	{
		$this->is_allowed('chat_contact_list');

		$filter = $this->input->get('q');
		$field 	= $this->input->get('f');

		$this->data['chat_contacts'] = $this->model_chat_contact->get($filter, $field, $this->limit_page, $offset);
		$this->data['chat_contact_counts'] = $this->model_chat_contact->count_all($filter, $field);

		$config = [
			'base_url'     => ADMIN_NAMESPACE_URL  . '/chat_contact/index/',
			'total_rows'   => $this->data['chat_contact_counts'],
			'per_page'     => $this->limit_page,
			'uri_segment'  => 4,
		];

		$this->data['pagination'] = $this->pagination($config);
		
		$this->data['tables'] = $this->load->view('backend/standart/administrator/chat_contact/chat_contact_data_table', $this->data, true);
		
		if ($this->input->get('ajax')) {
			$this->response([
				'tables' => $this->data['tables'],
				'pagination' => $this->data['pagination'],
				'total_row' => $this->data['chat_contact_counts']
			]);
		}

		$this->template->title('Chat Contact List');
		$this->render('backend/standart/administrator/chat_contact/chat_contact_list', $this->data);
	}
	
	/**
	* Add new chat_contacts
	*
	*/
	public function add()
	{
		$this->is_allowed('chat_contact_add');

		$this->template->title('Chat Contact New');
		$this->render('backend/standart/administrator/chat_contact/chat_contact_add', $this->data);
	}

	/**
	* Add New Chat Contacts
	*
	* @return JSON
	*/
	public function add_save()
	{
		if (!$this->is_allowed('chat_contact_add', false)) {
			echo json_encode([
				'success' => false,
				'message' => cclang('sorry_you_do_not_have_permission_to_access')
				]);
			exit;
		}
		
		

		$this->form_validation->set_rules('user_id', 'User Id', 'trim|required|max_length[11]');
		

		$this->form_validation->set_rules('contact_id', 'Contact Id', 'trim|required|max_length[11]');
		

		

		if ($this->form_validation->run()) {
		
			$save_data = [
				'user_id' => $this->input->post('user_id'),
				'contact_id' => $this->input->post('contact_id'),
			];

			
			



			
			
			$save_chat_contact = $id = $this->model_chat_contact->store($save_data);
            

			if ($save_chat_contact) {
				
				
					
				
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = true;
					$this->data['id'] 	   = $save_chat_contact;
					$this->data['message'] = cclang('success_save_data_stay', [
						admin_anchor('/chat_contact/edit/' . $save_chat_contact, 'Edit Chat Contact'),
						admin_anchor('/chat_contact', ' Go back to list')
					]);
				} else {
					set_message(
						cclang('success_save_data_redirect', [
						admin_anchor('/chat_contact/edit/' . $save_chat_contact, 'Edit Chat Contact')
					]), 'success');

            		$this->data['success'] = true;
					$this->data['redirect'] = admin_base_url('/chat_contact');
				}
			} else {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = false;
					$this->data['message'] = cclang('data_not_change');
				} else {
            		$this->data['success'] = false;
            		$this->data['message'] = cclang('data_not_change');
					$this->data['redirect'] = admin_base_url('/chat_contact');
				}
			}

		} else {
			$this->data['success'] = false;
			$this->data['message'] = 'Opss validation failed';
			$this->data['errors'] = $this->form_validation->error_array();
		}

		$this->response($this->data);
	}
	
		/**
	* Update view Chat Contacts
	*
	* @var $id String
	*/
	public function edit($id)
	{
		$this->is_allowed('chat_contact_update');

		$this->data['chat_contact'] = $this->model_chat_contact->find($id);

		$this->template->title('Chat Contact Update');
		$this->render('backend/standart/administrator/chat_contact/chat_contact_update', $this->data);
	}

	/**
	* Update Chat Contacts
	*
	* @var $id String
	*/
	public function edit_save($id)
	{
		if (!$this->is_allowed('chat_contact_update', false)) {
			echo json_encode([
				'success' => false,
				'message' => cclang('sorry_you_do_not_have_permission_to_access')
				]);
			exit;
		}
				$this->form_validation->set_rules('user_id', 'User Id', 'trim|required|max_length[11]');
		

		$this->form_validation->set_rules('contact_id', 'Contact Id', 'trim|required|max_length[11]');
		

		
		if ($this->form_validation->run()) {
		
			$save_data = [
				'user_id' => $this->input->post('user_id'),
				'contact_id' => $this->input->post('contact_id'),
			];

			

			


			
			
			$save_chat_contact = $this->model_chat_contact->change($id, $save_data);

			if ($save_chat_contact) {

				

				
				
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = true;
					$this->data['id'] 	   = $id;
					$this->data['message'] = cclang('success_update_data_stay', [
						admin_anchor('/chat_contact', ' Go back to list')
					]);
				} else {
					set_message(
						cclang('success_update_data_redirect', [
					]), 'success');

            		$this->data['success'] = true;
					$this->data['redirect'] = admin_base_url('/chat_contact');
				}
			} else {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = false;
					$this->data['message'] = cclang('data_not_change');
				} else {
            		$this->data['success'] = false;
            		$this->data['message'] = cclang('data_not_change');
					$this->data['redirect'] = admin_base_url('/chat_contact');
				}
			}
		} else {
			$this->data['success'] = false;
			$this->data['message'] = 'Opss validation failed';
			$this->data['errors'] = $this->form_validation->error_array();
		}

		$this->response($this->data);
	}
	
	/**
	* delete Chat Contacts
	*
	* @var $id String
	*/
	public function delete($id = null)
	{
		$this->is_allowed('chat_contact_delete');

		$this->load->helper('file');

		$arr_id = $this->input->get('id');
		$remove = false;

		if (!empty($id)) {
			$remove = $this->_remove($id);
		} elseif (count($arr_id) >0) {
			foreach ($arr_id as $id) {
				$remove = $this->_remove($id);
			}
		}

		if ($this->input->get('ajax')) {
			if ($remove) {
				$this->response([
					"success" => true,
					"message" => cclang('has_been_deleted', 'chat_contact')
				]);
			} else {
				$this->response([
					"success" => true,
					"message" => cclang('error_delete', 'chat_contact')
				]);
			}

		} else {
			if ($remove) {
				set_message(cclang('has_been_deleted', 'chat_contact'), 'success');
			} else {
				set_message(cclang('error_delete', 'chat_contact'), 'error');
			}
			redirect_back();
		}

	}

		/**
	* View view Chat Contacts
	*
	* @var $id String
	*/
	public function view($id)
	{
		$this->is_allowed('chat_contact_view');

		$this->data['chat_contact'] = $this->model_chat_contact->join_avaiable()->filter_avaiable()->find($id);

		$this->template->title('Chat Contact Detail');
		$this->render('backend/standart/administrator/chat_contact/chat_contact_view', $this->data);
	}
	
	/**
	* delete Chat Contacts
	*
	* @var $id String
	*/
	private function _remove($id)
	{
		$chat_contact = $this->model_chat_contact->find($id);

		
		
		return $this->model_chat_contact->remove($id);
	}
	
	
	/**
	* Export to excel
	*
	* @return Files Excel .xls
	*/
	public function export()
	{
		$this->is_allowed('chat_contact_export');

		$this->model_chat_contact->export(
			'chat_contact', 
			'chat_contact',
			$this->model_chat_contact->field_search
		);
	}

	/**
	* Export to PDF
	*
	* @return Files PDF .pdf
	*/
	public function export_pdf()
	{
		$this->is_allowed('chat_contact_export');

		$this->model_chat_contact->pdf('chat_contact', 'chat_contact');
	}


	public function single_pdf($id = null)
	{
		$this->is_allowed('chat_contact_export');

		$table = $title = 'chat_contact';
		$this->load->library('HtmlPdf');
      
        $config = array(
            'orientation' => 'p',
            'format' => 'a4',
            'marges' => array(5, 5, 5, 5)
        );

        $this->pdf = new HtmlPdf($config);
        $this->pdf->setDefaultFont('stsongstdlight'); 

        $result = $this->db->get($table);
       
        $data = $this->model_chat_contact->find($id);
        $fields = $result->list_fields();

        $content = $this->pdf->loadHtmlPdf('core_template/pdf/pdf_single', [
            'data' => $data,
            'fields' => $fields,
            'title' => $title
        ], TRUE);

        $this->pdf->initialize($config);
        $this->pdf->pdf->SetDisplayMode('fullpage');
        $this->pdf->writeHTML($content);
        $this->pdf->Output($table.'.pdf', 'H');
	}

	
}


/* End of file chat_contact.php */
/* Location: ./application/controllers/administrator/Chat Contact.php */