<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Widged_image extends Cc_widged
{
	public $table_name = 'widged_image';

	public $primary_key = 'id';

	public $widged_type = 'image';
	public $widged_group = 'element';

	public function __construct()
	{
		$this->setWidgedInstance($this);
		$this->setWidgedPath(__DIR__);

		app()->load->language('image/widged');
	}

	public function install($migrate)
	{
		$migrate->add_field(array(
			'id' => array(
				'type' => 'INT',
				'constraint' => 11,
				'unsigned' => TRUE,
				'auto_increment' => TRUE
			),
			'title' => array(
				'type' => 'VARCHAR',
				'constraint' => 200,
			),
			'link' => array(
				'type' => 'TEXT',
			),
			'image' => array(
				'type' => 'TEXT',
			),
			'widged_id' => array(
				'type' => 'INT',
			)
		));
		$migrate->add_key('id', TRUE);
		$migrate->create_table($this->table_name, true);
	}

	public function uninstall($migrate)
	{
		$migrate->drop_table($this->table_name, TRUE);
	}

	/**
	$data = [
		'widged_id',
		'id'
	];
	 */
	public function getWidgedConfig($data)
	{
		return [
			'status' => true,
			'contents' => $this->view('widged_image_setting', $data, true)
		];
	}
	public function config()
	{
		return [
			'grid_min_height' => 1,
			'grid_min_width' => 2,
			'grid_max_height' => 12,
			'grid_max_width' => 12,
			'grid_default_width' => 2,
			'grid_default_height' => 2,
			'icon' => '<img src="' . $this->widgedAssetUrl('asset/img/logo.png') . '" alt="">',
			'description' => "Image widged",
			'use_box_wrapper' => false
		];
	}

	public function updateValidation($data = [])
	{
		return [
			['title', 'title', 'trim'],
		];
	}

	public function create($data = [])
	{
		return [
			'widged_id' => $data['widged_id'],
			'title' => 'Image',
			'link' => '/',
			'image' => '',
		];
	}

	public function update($data = [])
	{
		$input = $data['input'];

		$listed_image = [];
		if (count((array) $input->get('image_name'))) {
			if (!is_dir(FCPATH . 'uploads/widged_image/')) {
				mkdir(FCPATH . 'uploads/widged_image/');
			}
			foreach ((array) $_POST['image_name'] as $idx => $file_name) {
				if (isset($_POST['image_uuid'][$idx]) and !empty($_POST['image_uuid'][$idx])) {
					$image_name_copy = date('YmdHis') . '-' . $file_name;

					rename(
						FCPATH . 'uploads/tmp/' . $_POST['image_uuid'][$idx] . '/' .  $file_name,
						FCPATH . 'uploads/widged_image/' . $image_name_copy
					);


					$listed_image[] = $image_name_copy;

					if (!is_file(FCPATH . '/uploads/widged_image/' . $image_name_copy)) {
						echo json_encode([
							'success' => false,
							'message' => 'Error uploading file'
						]);
						exit;
					}
				} else {
					$listed_image[] = $file_name;
				}
			}
		}

		$images = implode(',', (array)$listed_image);

		return [
			'title' => $input->get('title'),
			'link' => $input->get('link'),
			'image' => $images,
		];
	}

	/**
	$data = [
		'widged_id',
	];
	 */
	public function afterUpdate($data = [], $input)
	{
	}

	public function render($meta)
	{
		$element = function ($widged) use ($meta) {

			$images = [];
			foreach (explode(',', $meta->child->get('image')) as $file) {
				$src = BASE_URL . 'uploads/widged_image/' . $file;
				$images[] = $widged->el('a[href="' . $meta->child->get('link') . '"]', $widged->el('img[src="' . $src . '"].image-item'));
			}

			$title = $meta->get('title') ? $widged->el('h3', [
				$meta->get('title')
			]) : '';

			return $widged->el(

				'div.image-wrapper#-' . $meta->get('id'),
				[
					$widged->el('div.inner', [
						$title,
						$widged->el(
							'div',
							$images
						),
					]),

				]
			);
		};


		return $this->widged([
			'meta' => $meta,
			'body' => $element
		]);
	}


	public function uploadImageFile()
	{
		$uuid = app()->input->post('qquuid');

		$default = [
			'uuid' 		 	=> $uuid,
			'allowed_types' => 'jpg|jpeg|png',
			'upload_path'   => './uploads/tmp/',
			'input_files'   => 'qqfile',
			'table_name'    => 'widged_image',
		];


		$dir = FCPATH . $default['upload_path'] . $default['uuid'];
		if (!is_dir($dir)) {
			mkdir($dir);
		}

		if (empty($default['file_name'])) {
			$default['file_name'] = date('Y-m-d') . $default['table_name'] . date('His');
		}

		$config = [
			'upload_path'       => $default['upload_path'] . $default['uuid'] . '/',
			'allowed_types'     => $default['allowed_types'],
			'file_name'         => $default['file_name']
		];

		app()->load->library('upload', $config);
		app()->load->helper('file');

		if (!app()->upload->do_upload('qqfile')) {
			$result = [
				'success'   => false,
				'error'     =>  app()->upload->display_errors()
			];

			die(json_encode($result));
		} else {
			$upload_data = app()->upload->data();

			$result = [
				'uploadName'    => $upload_data['file_name'],
				'previewLink'  => $dir . '/' . $upload_data['file_name'],
				'success'       => true,
			];

			die(json_encode($result));
		}
	}


	public function getImageFile($meta)
	{
		$default = [
			'uuid'              => $meta->get('id'),
			'delete_by'         => 'id',
			'field_name'        => 'image',
			'table_name'        => 'widged_image',
			'primary_key'       => 'id',
			'upload_path'       => 'uploads/widged_image/',
			'delete_endpoint'   => ADMIN_NAMESPACE_URL . '/widged_image/delete_image_file'
		];

		$row = app()->db->get_where($default['table_name'], [$default['primary_key'] => $default['uuid']])->row();

		if (!$row) {
			$result = [
				'error' =>  'Error getting file'
			];

			return json_encode($result);
		} else {
			if (!empty($row->{$default['field_name']})) {

				$result = [];

				foreach (explode(',', $row->{$default['field_name']}) as $filename) {
					$result[] = [
						'success'               => true,
						'thumbnailUrl'          => check_is_image_ext(base_url($default['upload_path'] . $filename)),
						'id'                    => 0,
						'name'                  => $row->{$default['field_name']},
						'uuid'                  => $row->{$default['primary_key']},
						'deleteFileEndpoint'    => base_url($default['delete_endpoint']),
						'deleteFileParams'      => ['by' => $default['delete_by']]
					];
				}


				echo json_encode($result);
				exit;
			}
		}
	}


	public function URLResource()
	{
		return ['uploadImageFile', 'getImageFile'];
	}

	public function JS()
	{
		return [
			'asset/js/image.js',
		];
	}

	public function CSS()
	{
		return [
			'asset/css/image.css'
		];
	}
}
