<?php
defined('BASEPATH') OR exit('No direct script access allowed');


/**
*| --------------------------------------------------------------------------
*| Form Sadasd Controller
*| --------------------------------------------------------------------------
*| Form Sadasd site
*|
*/
class Form_sadasd extends Admin	
{
	
	public function __construct()
	{
		parent::__construct();

		$this->load->model('model_form_sadasd');
	}

	/**
	* show all Form Sadasds
	*
	* @var $offset String
	*/
	public function index($offset = 0)
	{
		$this->is_allowed('form_sadasd_list');

		$filter = $this->input->get('q');
		$field 	= $this->input->get('f');

		$this->data['form_sadasds'] = $this->model_form_sadasd->get($filter, $field, $this->limit_page, $offset);
		$this->data['form_sadasd_counts'] = $this->model_form_sadasd->count_all($filter, $field);

		$config = [
			'base_url'     => ADMIN_NAMESPACE_URL  . '/manage-form/form_sadasd/index/',
			'total_rows'   => $this->model_form_sadasd->count_all($filter, $field),
			'per_page'     => $this->limit_page,
			'uri_segment'  => 5,
		];

		$this->data['pagination'] = $this->pagination($config);

		$this->template->title('Aasdad List');
		$this->render('backend/standart/administrator/form_builder/form_sadasd/form_sadasd_list', $this->data);
	}

	/**
	* Update view Form Sadasds
	*
	* @var $id String
	*/
	public function edit($id)
	{
		$this->is_allowed('form_sadasd_update');

		$this->data['form_sadasd'] = $this->model_form_sadasd->find($id);

		$this->template->title('Aasdad Update');
		$this->render('backend/standart/administrator/form_builder/form_sadasd/form_sadasd_update', $this->data);
	}

	/**
	* Update Form Sadasds
	*
	* @var $id String
	*/
	public function edit_save($id)
	{
		if (!$this->is_allowed('form_sadasd_update', false)) {
			echo json_encode([
				'success' => false,
				'message' => cclang('sorry_you_do_not_have_permission_to_access')
				]);
			exit;
		}
		
		$this->form_validation->set_rules('email', 'Email', 'trim|required');
		$this->form_validation->set_rules('password', 'Password', 'trim|required');
		
		if ($this->form_validation->run()) {
		
			$save_data = [
				'email' => $this->input->post('email'),
				'password' => $this->input->post('password'),
			];

			
			$save_form_sadasd = $this->model_form_sadasd->change($id, $save_data);

			if ($save_form_sadasd) {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = true;
					$this->data['id'] 	   = $id;
					$this->data['message'] = cclang('success_update_data_stay', [
						admin_anchor('/form_sadasd', ' Go back to list')
					]);
				} else {
					set_message(
						cclang('success_update_data_redirect', [
					]), 'success');

            		$this->data['success'] = true;
					$this->data['redirect'] = admin_base_url('/form_sadasd');
				}
			} else {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = false;
					$this->data['message'] = cclang('data_not_change');
				} else {
					set_message('Your data not change.', 'error');
					
            		$this->data['success'] = false;
					$this->data['message'] = cclang('data_not_change');
					$this->data['redirect'] = admin_base_url('/form_sadasd');
				}
			}
		} else {
			$this->data['success'] = false;
			$this->data['message'] = validation_errors();
		}

		echo json_encode($this->data);
	}

	/**
	* delete Form Sadasds
	*
	* @var $id String
	*/
	public function delete($id = null)
	{
		$this->is_allowed('form_sadasd_delete');

		$this->load->helper('file');

		$arr_id = $this->input->get('id');
		$remove = false;

		if (!empty($id)) {
			$remove = $this->_remove($id);
		} elseif (count($arr_id) >0) {
			foreach ($arr_id as $id) {
				$remove = $this->_remove($id);
			}
		}

		if ($remove) {
            set_message(cclang('has_been_deleted', 'Form Sadasd'), 'success');
        } else {
            set_message(cclang('error_delete', 'Form Sadasd'), 'error');
        }

		redirect_back();
	}

	/**
	* View view Form Sadasds
	*
	* @var $id String
	*/
	public function view($id)
	{
		$this->is_allowed('form_sadasd_view');

		$this->data['form_sadasd'] = $this->model_form_sadasd->find($id);

		$this->template->title('Aasdad Detail');
		$this->render('backend/standart/administrator/form_builder/form_sadasd/form_sadasd_view', $this->data);
	}

	/**
	* delete Form Sadasds
	*
	* @var $id String
	*/
	private function _remove($id)
	{
		$form_sadasd = $this->model_form_sadasd->find($id);

		
		return $this->model_form_sadasd->remove($id);
	}
	
	/**
	* Export to excel
	*
	* @return Files Excel .xls
	*/
	public function export()
	{
		$this->is_allowed('form_sadasd_export');

		$this->model_form_sadasd->export('form_sadasd', 'form_sadasd');
	}
}


/* End of file form_sadasd.php */
/* Location: ./application/controllers/administrator/Form Sadasd.php */